import java.awt.event.ActionEvent;

import javax.swing.JButton;

import acm.program.*;
public class Karel extends Program {
	private KarelDisplay display;
	private KarelWorld world;
	
	private static final int DEFAULT_ROWS = 8;
	private static final int DEFAULT_COLS = 8;
	
	public void init() {
		display = new KarelDisplay();
		world = new KarelWorld(DEFAULT_ROWS, DEFAULT_COLS);
		
		display.setWorld(world);		
		add(display);
		
		add(new JButton("move"), SOUTH);
		add(new JButton("turnLeft"), SOUTH);
		add(new JButton("pickBeeper"), SOUTH);
		add(new JButton("putBeeper"), SOUTH);
		addActionListeners();
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals("move")) {
			move();
		} else if (e.getActionCommand().equals("turnLeft")) {
			turnLeft();
		}
	}
	
	public void move() {
		world.move();
		display.update();
	}
	
	public void turnLeft() {
		world.turnLeft();
		display.update();
	}
	
	public void run() {
		display.update();
	}
}
